// Copyright 1996 by Jon Dart.  All Rights Reserved
#ifndef __BOOKDEFS_H__
#define __BOOKDEFS_H__

// definitions and constants related to the internal format
// of the opening book (BOOK.BIN)

#include "types.h"
#include "bookentr.h"

#define INVALID (uint16)0xffff

#define Entry_Size 10
#define Book_Version 6

enum styles { Balanced, Gambit, Unusual, Aggressive, Closed };

struct Book_Header
{
   byte version;
   byte num_pages;
   uint32 page_capacity;
   uint32 hash_table_size;
};

#define Header_Size sizeof(Book_Header)
#define MAIN_BOOK_NAME "book.bin"
#define MAIN_MAPPING_NAME "Arasan opening book"
#define STYLE_BOOK_NAME "styles.bin"
#define STYLE_MAPPING_NAME "Arasan opening styles"
#define MAX_STYLES 16
#define MAXBOOKBITS 10


#endif
